'''
Description: Script to detect a disconnect
Author: Frans Jacobs
Date: 10-6-2016
'''

import os
# Used for creating lists
import System.Collections.ObjectModel
from System import DateTime

import clr
import sys
import logging
import time

# set the path for the DCNm assemblies and load the assembly for the API
# set the path for the DCNm assemblies and load the assembly for the API
sys.path.append(r"C:\Program Files\Bosch\DICENTIS")
sys.path.append(r"C:\Program Files (x86)\Bosch\DICENTIS")
if os.environ.has_key("MMCN_HOME"):
    sys.path.append(os.environ['MMCN_HOME'] + "\obj\winntApp\OBFUSCATED")
    sys.path.append(os.environ['MMCN_HOME'] + "\obj\winntApp\DEBUG\Mmcn\Interfaces\Api")
print(sys.path)

clr.AddReference("Bosch.Dcnm.Interfaces.Api")
import Bosch.Dcnm.Interfaces.Api
clr.AddReference("Bosch.Dcnm.Interfaces.Api.Interfaces")
from Bosch.Dcnm.Interfaces.Api.Interfaces import *


global devices


def disconnectHandler(sender,args): 
    global devices
    for item in args.Parameter:
        device = devices[item]
        if device is None:
            logging.info("DevicesDisconnected event fired, device name is: {0}".format(item))
        else:
            logging.info("DevicesDisconnected event fired, device name is: {0}".format(device.Name))


def connectHandler(sender,args): 
    global devices
    for item in args.Parameter:
        logging.info("DevicesConnected event fired, device name is: {0}".format(item.Name))


def stateChangeHandler(sender,args):
    updateDeviceList = False
    for item in args.Parameter:
        logging.info("EquipmentOperationalStateChanged event fired, {0} is now in state: {1}".format(item.Name, item.DeviceState))
        if item.DeviceState == DcnmDeviceOperationalState.Operational:
            updateDeviceList = True
			
    if updateDeviceList:
        # Update global list of devices
        d = api.Equipment.GetDevicesAsync().Result
        for device in d:
            devices[device.Id] = device;
#         #print list of devices when a new device is operational
#         for device in devices:
#             logging.info(device.Name)


def unhookOffEvents():
    api.Equipment.DevicesDisconnected -= disconnectHandler
    api.Equipment.DevicesConnected -= connectHandler
    api.Equipment.EquipmentOperationalStateChanged -= stateChangeHandler
    logging.info("Unhooked from events...")


def hookToEvents():
    api.Equipment.DevicesDisconnected += disconnectHandler
    api.Equipment.DevicesConnected += connectHandler
    api.Equipment.EquipmentOperationalStateChanged += stateChangeHandler
    logging.info("Hooked to events! :) If devices disconnect/change status it will appear below...")

def DetectDisconnect():
    hookToEvents()
    global devices
    devices = {}
    # Create global list of devices
    d = api.Equipment.GetDevicesAsync().Result
    for device in d:
        devices[device.Id] = device;
		
#     #print list of devices at start of script
#     for device in devices:
#         logging.info(device.Name)


    #loop to let script run until user tells it to stop
    while True:
        time.sleep(1)


# Main program
execfile("DcnmApi.py")
ConfigureLogging("DetectDisconnect", logging.DEBUG, True)
api = CreateApiInstance()

# Start the test.
try:
    DetectDisconnect()
except KeyboardInterrupt:
    logging.info("Closing the script, because of a keyboard interrupt")
    unhookOffEvents()
#     unhookOffEvent("Equipment.DevicesConnected")
except Exception as e:
    logging.exception(e)
    unhookOffEvents()
    os._exit(1)
    

try:
    logging.info("above DisposeApiInstance call")
    DisposeApiInstance(api)
    logging.info("below DisposeApiInstance call")
except:
    logging.info("Exception when trying to dispose of API")
    os._exit(1)
    
    
logging.info("End of script")
os._exit(0)