import clr
import sys
import time
import socket
import System
import logging
import subprocess
import os
import re

# set the path for the DCNm assemblies and load the assembly for the API
sys.path.append(r"C:\Program Files\Bosch\DICENTIS")
sys.path.append(r"C:\Program Files (x86)\Bosch\DICENTIS")
if os.environ.has_key("MMCN_HOME"):
    sys.path.append(os.environ['MMCN_HOME'] + "\obj\winntApp\OBFUSCATED")
    sys.path.append(os.environ['MMCN_HOME'] + "\obj\winntApp\DEBUG\Mmcn\Interfaces\Api")
print(sys.path)

clr.AddReference("Bosch.Dcnm.Interfaces.Api")
import Bosch.Dcnm.Interfaces.Api
clr.AddReference("Bosch.Dcnm.Interfaces.Api.Interfaces")
from Bosch.Dcnm.Interfaces.Api.Interfaces import *

# global variables
LOGGING_COLLECTOR_PATH = "..\\Tools\logcollector\Collector.cmd"
    
defaultAreaGuid = "E101C350-FC33-4CB5-AEA5-134CDE1714E7"

# Wait for a property to become a certain value. Maximum number of 
# attempts and text when the property is not set in time 
# are given as parameters.
def WaitForProperty(object, property, value, max_attempts, failure_text):
    i = max_attempts
    propvalue = property.GetValue(object)
    while ( (propvalue != value) and (i > 0) ):
        i = i - 1
        time.sleep(1)
        propvalue = property.GetValue(object)
    if (propvalue != value):        
        logging.error(failure_text)
        raise Exception(failure_text)

# Configuration the logging, optional logging to console
def ConfigureLogging(filename="Pythonlog", loglevel=logging.DEBUG, consoleAlso=False):
    loggingFilename = filename + "-" + time.strftime("%Y%m%d-%H%M%S") + ".txt"
    logging.basicConfig(filename=loggingFilename,format='%(asctime)s %(levelname)-8s: %(message)s', filemode='w',level=loglevel)
    if (consoleAlso):
        console = logging.StreamHandler()
        formatter = logging.Formatter('%(asctime)s %(levelname)-8s: %(message)s')
        console.setFormatter(formatter)
        logging.getLogger('').addHandler(console)

#report a test result
def ReportResult(test, result):
    global exitcode
    if result:
        logging.info ("PASS - %s", test)
    else:
        exitcode = 1
        logging.error ("FAIL - %s", test)


def CollectSystemLogging():
    subprocess.call(LOGGING_COLLECTOR_PATH)


# Print the state of the api
def PrintApiState(api):
    logging.debug("API state:")
    logging.debug("api.Base.IsOpen                          = %s", str(IApi.IsOpen.GetValue(api.Base)))
    logging.debug("api.Base.CurrentApiState                 = %s", str(IApi.CurrentApiState.GetValue(api.Base)))
    logging.debug("api.Device.CurrentDeviceConnectionState  = %s", str(IDeviceApi.CurrentDeviceConnectionState.GetValue(api.Device)))
    logging.debug("api.Device.CurrentApplicationState       = %s", str(IDeviceApi.CurrentApplicationState.GetValue(api.Device)))
    logging.debug("api.Device.IsEnabledAsDevice             = %s", str(IDeviceApi.IsEnabledAsDevice.GetValue(api.Device)))

def ApiStateChanged(sender, args):
    logging.debug("Apistate changed - new state is %s", args.Parameter)
    
def CreateApiInstance(name=""):
    if (name == ""):
        name = ("PythonTestScript")

    api = Bosch.Dcnm.Interfaces.Api.MainWindowsApi
    api.SystemVideoControl
    api.Equipment
    
    if not api.Base.OpenAsync().Result:
        logging.error("Failed to open the api")

    WaitForProperty(api.Base, IApi.IsOpen, True, 180, "Opening API not succeeded in time")
    
    WaitForProperty(api.Base, IApi.CanAuthenticate, True, 30, "Can authenticate still not possible")
    if not api.Base.AuthenticateUserAsync("admin", "").Result:
        logging.error("Could not authenticate as admin")
    
    WaitForProperty(api.Device, IDeviceApi.CanConnectAsDevice, True, 30, "Timeout while waiting for ability to connect as a device")
    if not api.Device.ConnectAsDeviceAsync(name).Result:
        logging.error("Failed to connect as a device")

    WaitForProperty(api.Device, IDeviceApi.CurrentDeviceConnectionState, DcnmDeviceConnectionState.Connected, 30, "Connect as a device not done in time")
    WaitForProperty(api.Device, IDeviceApi.IsEnabledAsDevice, True, 60, "Open of API not enabled in time, make sure that the Automatic Seat Assignment setting is ON")
    
    api.Base.ApiStateChanged += ApiStateChanged
    
    PrintApiState(api)
    
    return api

def DisposeApiInstance(api):
    api.Base.ApiStateChanged -= ApiStateChanged
    if "Shutdown" in dir(api):
        try:
            logging.info("now try to dispose of API (shutdown call)")
            api.Shutdown()
        except:
            logging.error("problem getting rid of API instance (shutdown call)")
    elif "Exit" in dir(api):
        try:
            logging.info("now try to dispose of API (exit call)")
            api.Exit()
        except:
            logging.error("problem getting rid of API instance (exit call)")
    else:
        logging.error("Both api.Shutdown() and api.Exit() not available! Unable to close the API connection")

def Set_PythonTestScript_Rights(api, manage_meeting_right=True, discuss_right=True):
    # Get default area and the seats present there
    areas = IConfigSite.GetAreasAsync(api.ConfigSite).Result
        
    for a in areas:
        areaId = DcnmAreaConfigurationInfo.Id.GetValue(a)

        print areaId
        if (str(areaId).upper() == defaultAreaGuid):            
            defaultAreId = areaId
            break 
            
    ReportResult("Set_PythonTestScript_Rights: Retrieve default area: " + str(defaultAreId), defaultAreId is not None)
    seats = IInstallArea.GetAssignedSeatsAsync(api.InstallArea, defaultAreId).Result
    
    # Find our own seat by looping through all seats in the area and finding the corresponding device with name containing 'PythonTestScript'
    # and set Discuss rights and Manage Meeting rights
    
    PythonSeatId = None
    for s in seats:
        devices = s.Devices
        for d in devices:
            deviceName = d.Name
            if re.search("PythonTestScript", deviceName, flags=re.IGNORECASE):
                logging.info("Preparing {} with device {}, setting manage meeting rights: {}, discuss rights: {}".format(s.Name, d.Name, manage_meeting_right, discuss_right))
                seatsInArea = IConfigArea.GetSeatsAsync(api.ConfigArea, defaultAreId).Result
                for areaSeat in seatsInArea:
                    if areaSeat.Id == s.Id:
                        seatNew = DcnmSeatConfigurationInfo(areaSeat.Id, areaSeat.Name, areaSeat.AreaId, areaSeat.VisType, discuss_right, manage_meeting_right, areaSeat.CanUsePriority, areaSeat.HasLanguageDistributionLicense, areaSeat.HasVotingLicense, areaSeat.CameraId, areaSeat.PrepositionId)
                        IConfigArea.UpdateSeatsAsync(api.ConfigArea, [seatNew]).Result
