cls
@echo off

rem The destination path can be defined here:
set copypath=C:\DicentisDiagData

rem This is the location of a temporary folder, this will be automatically deleted: 
set TEMPDIR=C:\DICENTIStemp

FOR /f %%a IN ('WMIC OS GET LocalDateTime ^| find "."') do set DTS=%%a
set DateTime=%DTS:~0,4%%DTS:~4,2%%DTS:~6,2%_%DTS:~8,2%%DTS:~10,2%%DTS:~12,2%

set FileVersion=1.00

rem update 0.95(Date 01-02-2024): -added Logdump.exe to generate a logfile i.s.o. creating a backup with the SQL commandline. 
rem 						    : -added WMIC PRODUCT, to generate a list of installed software + version + install date
rem update 0.96(Date 21-02-2024): -added backup of MediaGateway Config 
rem								  -added backup of %programdata%/Bosch/DICENTIS/*.*
rem update 0.97(Date 08-03-2024): -added CPU detail logging
rem
rem update 0.98(Date 16-04-2024): -added GPU detail logging
rem		
rem update 0.99(Date 28-08-2024): -added Hotfix installation logging
rem			
rem update 1.00(Date 28-09-2024): -Fixed incorrect collection of ProgramData information						 
c:
cd\
IF exist C:\DicentisDiagData ( echo. ) ELSE ( mkdir %copypath% )
color F0

ClS
ECHO.
ECHO. 
ECHO      This tool (DICENTIS Diasgnostic Data Collector)
ECHO.            will generate a zip archive in 
ECHO           which we include system information
ECHO           extracted from your DICENTIS server
ECHO           for trouble shouting purposes only
ECHO.         
ECHO.      
ECHO.
ECHO.
ECHO        Run the script with Administrator rights!
echo.
echo.
echo.
echo.
ECHO                     Version %FileVersion%
ECHO.
ECHO.
echo.
echo Do you want to continue? Y/N
echo.
SET INPUT=
SET /P INPUT=(Y/N):
ClS
IF /I '%INPUT%'=='Y' GOTO DiagData1
IF /I '%INPUT%'=='N' exit



:PrepareZipData
c:
cd\
cd data\tools
@echo off
rmdir %TEMPDIR% /s /q 
mkdir %TEMPDIR%
mkdir %TEMPDIR%\TMP
cd "C:\Program Files\Bosch\DICENTIS"
cls
echo backup database serverconsole
DcnmDatabaseConsole.exe -b "%copypath%\DbBackup_%DateTime%.bak" 
mkdir %TEMPDIR%\Data
xcopy C:\inetpub\wwwroot\DcnmSynopticControl\Data %TEMPDIR%\Data /S /E
echo .zip > %TEMPDIR%\zip.txt
echo off
xcopy /s %copypath% %TEMPDIR% /exclude:%TEMPDIR%\zip.txt
xcopy /s %copypath%/Data %TEMPDIR%/Data
echo Version_%FileVersion% > %TEMPDIR%\Tool_Version_%FileVersion%.txt
del /q %TEMPDIR%\zip.txt
del /q %copypath%\*.log
del /q %copypath%\*.bak
del /q %copypath%\*.txt
del /q %copypath%\*.htm
del /q %copypath%\*.html
del /q %copypath%\*.evtx
del /q %copypath%\*.json*
rd /s /q %copypath%\ProgramData
rd /s /q %copypath%\TMP
goto zip

:zip
rem This part archives the harvested data in a zip-file
cls
powershell Compress-Archive -path %TEMPDIR%\* %copypath%\%DateTime%.zip
rmdir /s /q %TEMPDIR%
goto quit

:DiagData1
CLS
@echo off
cd /D %Temp%
set lastChar=%TEMP:~-4%
if not %lastChar% == Temp cd..
xcopy Bosch_DICENTIS* %copypath%\TMP\
xcopy OMNEO* %copypath%\TMP\
xcopy Dante* %copypath%\TMP\
xcopy Network* %copypath%\TMP\
xcopy "C:\Program Files (x86)\Bosch\DICENTIS Hybrid\MediaGateway\MediaGatewaySettings.jsonc" %copypath%
CLS
systeminfo > %copypath%\SystemInfo_%Computername%.txt
ipconfig /all > %copypath%\IpConfig_%Computername%.txt
route print > %copypath%\RoutePrint_%Computername%.txt
set > %copypath%\EnvironmentVariables_%Computername%.txt
wevtutil epl Application %copypath%\Application_log_%Computername%.evtx
wevtutil epl System %copypath%\System_log_%Computername%.evtx
xcopy /S /E /Q "%ProgramData%\Bosch\*" "%copypath%\ProgramData\Bosch\"
xcopy /S /E /Q "%ProgramData%\Audinate\*" "%copypath%\ProgramData\Audinate\"
rmdir /Q /S %copypath%\ProgramData\Bosch\DICENTIS\Apk\
rmdir /Q /S "%copypath%\ProgramData\Bosch\DICENTIS Firmware"
rmdir /Q /S %copypath%\ProgramData\Bosch\OMNEO\ARNI\
del %copypath%\ProgramData\Bosch\DICENTIS\*.x*
del %copypath%\ProgramData\Bosch\DICENTIS\*.txt
CLS
ECHO.
ECHO.
ECHO Generating a software list, this takes time. 
ECHO.
ECHO Please be patient, the tool did not stop.
wmic /output:"%copypath%\InstalledSW_%Computername%.txt" product get name,version,installdate
powershell "Get-WmiObject -Class Win32_Processor -ComputerName. | Select-Object -Property [a-z]*" > "%copypath%\InstalledCPU_%Computername%.txt"
powershell "Get-WmiObject -Class Win32_VideoController -ComputerName. | Select-Object -Property [a-z]*" > "%copypath%\InstalledGPU_%Computername%.txt"
powershell "Get-Hotfix" > "%copypath%\InstalledHotfix_%Computername%.txt"
CLS
if exist "C:\Program Files\BOSCH\DICENTIS\Logdump.exe" (goto Logdump)
else (goto SQL2014)


:SQL2014
rem For DICENTIS versions <3.60
SqlCmd -E -S .\SQLDICENTIS2014 -Q "BACKUP DATABASE [DcnmloggingDatabase] TO DISK='%copypath%\LoggingDbBackup_%DateTime%.bak'"
goto PrepareZipData

:Logdump
"C:\Program Files\BOSCH\DICENTIS\Logdump.exe" %copypath%\Logdump_%Computername%.txt
goto PrepareZipData 

:quit
cls
ECHO. 
ECHO. 
ECHO. 
ECHO. 
ECHO. 
ECHO. 
ECHO. 
ECHO.  
ECHO ===============================Finished===================================
ECHO. 
ECHO             The backup(s) can be found in %copypath%
ECHO.
ECHO =========================PRESS ANY KEY TO CONTINUE======================== 
PAUSE>NUL
exit