@echo off
echo #########################################################################
echo ##  DIVAR IP 4400 AIO - Enable Win8.1 DPI Scaling and DPI value to 96  ##
echo #########################################################################
echo. 
echo Script Version 1.0
echo Date 2023/06/05
rem Last modification by: Tony Sidorski
echo.

echo This script will then verify that the script was run as administrator. 
echo It will then make the appropriate registry scaling changes for both Limited and BVRAdmin users.
echo Information will be logged to C:\Users\Administrator\Desktop\ScriptLog.txt
echo.
echo **Please note that any modification of this script will not be supported.**
echo.


title DIVAR IP 4400 AIO - Enable Win8.1 DPI Scaling and DPI to 96
	

set textOutput=This is the limited user SID information:


	@echo off
		
		FOR /F "tokens=1,2" %%A in ('"echo %date%"') do set curDate=%%B
		echo %curDate% %time% >> C:\Users\Administrator\Desktop\ScriptLog.txt

		FOR /F "tokens=1,2" %%A in ('"wmic useraccount get name,sid |findstr limited"') do set userSID=%%B

		echo Fetching Kiosk user SID value: %userSID%
		echo.



		echo %textOutput% >> C:\Users\Administrator\Desktop\ScriptLog.txt
		wmic useraccount get name,sid |findstr limited >> C:\Users\Administrator\Desktop\ScriptLog.txt
		echo. >> C:\Users\Administrator\Desktop\ScriptLog.txt

		sc config "LanManServer" start=demand >> nul

		net start "LanManServer" >nul
			timeout /T 5 >nul

		goto check_Admin_Permissions

		:check_Admin_Permissions
			echo Administrative permissions required. Detecting permissions...
			
				net session >nul 2>&1
				
				if %errorLevel% == 0 (
        
					echo Administrative Access Level Confirmed!!
					echo.

					timeout /T 2 >nul

					echo Current Kiosk user DPI scaling value:
					REG QUERY "HKEY_USERS\%userSID%\Control Panel\Desktop" /v Win8DpiScaling
					REG QUERY "HKEY_USERS\%userSID%\Control Panel\Desktop" /v LogPixels
					echo.

					echo Current BVRAdim user DPI scaling value.
					REG QUERY "HKEY_CURRENT_USER\Control panel\Desktop" /v Win8DpiScaling
					REG QUERY "HKEY_CURRENT_USER\Control panel\Desktop" /v LogPixels
					echo.

					echo Current Kiosk user DPI scaling value: >> C:\Users\Administrator\Desktop\ScriptLog.txt
					REG QUERY "HKEY_USERS\%userSID%\Control Panel\Desktop" /v Win8DpiScaling >> C:\Users\Administrator\Desktop\ScriptLog.txt
					REG QUERY "HKEY_USERS\%userSID%\Control Panel\Desktop" /v LogPixels >> C:\Users\Administrator\Desktop\ScriptLog.txt
					
					echo Current BVRAdmin user DPI scaling value: >> C:\Users\Administrator\Desktop\ScriptLog.txt
					REG QUERY "HKEY_CURRENT_USER\Control Panel\Desktop" /v Win8DpiScaling >> C:\Users\Administrator\Desktop\ScriptLog.txt
					REG QUERY "HKEY_CURRENT_USER\Control Panel\Desktop" /v LogPixels >> C:\Users\Administrator\Desktop\ScriptLog.txt

					echo Changing Kiosk user DPI scaling value.
					REG ADD "HKEY_USERS\%userSID%\Control Panel\Desktop" /v Win8DpiScaling /t REG_DWORD /d 1 /f
					REG ADD "HKEY_USERS\%userSID%\Control Panel\Desktop" /v LogPixels /t REG_DWORD /d 96 /f
					echo.
					
					echo Changing BVRAdim user DPI scaling value.
					REG ADD "HKEY_CURRENT_USER\Control panel\Desktop" /v Win8DpiScaling /t REG_DWORD /d 1 /f
					REG ADD "HKEY_CURRENT_USER\Control panel\Desktop" /v LogPixels /t REG_DWORD /d 96 /f
					echo.

					echo New Kiosk user DPI scaling value:
					REG QUERY "HKEY_USERS\%userSID%\Control Panel\Desktop" /v Win8DpiScaling
					REG QUERY "HKEY_USERS\%userSID%\Control Panel\Desktop" /v LogPixels

					echo New BVRAdim user DPI scaling value:
					REG QUERY "HKEY_CURRENT_USER\Control panel\Desktop" /v Win8DpiScaling
					REG QUERY "HKEY_CURRENT_USER\Control panel\Desktop" /v LogPixels

					echo New Kiosk user DPI scaling value: >> C:\Users\Administrator\Desktop\ScriptLog.txt
					REG QUERY "HKEY_USERS\%userSID%\Control Panel\Desktop" /v Win8DpiScaling >> C:\Users\Administrator\Desktop\ScriptLog.txt
					REG QUERY "HKEY_USERS\%userSID%\Control Panel\Desktop" /v LogPixels >> C:\Users\Administrator\Desktop\ScriptLog.txt

					echo New BVRAdmin user DPI scaling value: >> C:\Users\Administrator\Desktop\ScriptLog.txt
					REG QUERY "HKEY_CURRENT_USER\Control Panel\Desktop" /v Win8DpiScaling >> C:\Users\Administrator\Desktop\ScriptLog.txt
					REG QUERY "HKEY_CURRENT_USER\Control Panel\Desktop" /v LogPixels >> C:\Users\Administrator\Desktop\ScriptLog.txt

				echo This script has completed successfully! Please restart your DIVAR IP 4400 AIO for the changes to take effect.
				echo.				
    ) else (

	Color FC
	echo Failure: Current user does not have proper permissions. Please exit and then run this as Administrator
	echo "The net session command generated an error" %errorLevel% 
        Pause	
    )

    sc config "LanManServer" start=disabled >nul

    net stop "LanManServer" >nul

	Pause

	:: DEBUG
Exit